####################################################
### code chunk number : Simulations: Two inequalities, Given (mu0, k0, v0, sigma0, x_np1)
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu0 = 3; mu0    ## hyperparameter
k0 = 1          ## hyperparameter
v0 = 6; v0      ## hyperparameter
sigma0 = 1      ## hyperparameter
u0 = sigma0^2 * (k0 + 1) / k0; u0

set.seed(1)
theta_np1 = 1 / rgamma(n = 1, shape = v0 / 2, rate = v0 * sigma0^2 / 2); theta_np1
mu_np1 = rnorm(n = 1, mean = mu0, sd = sqrt(theta_np1 / k0)); mu_np1
x_np1 = rnorm(n = 1, mean = mu_np1, sd = sqrt(theta_np1)); x_np1

res = Compute_PostDist_Estimators_PESLs_new(mu0, k0, v0, sigma0, x_np1); res[2:5]
range(res$PostDist_theta)
length(res$PostDist_theta)

dev.new()
xlim = c(0, 10)
# xlim = range(res$PostDist_theta)
ylim = c(0, 0.5)
hist(res$PostDist_theta, freq = FALSE, breaks = 200, 
     xlab = expression(paste(theta[n+1], "|", x[n+1])), ylab = expression( pi(paste(theta[n+1], "|", x[n+1]))),
     main = expression(paste("Histogram of ", theta[n+1], "|", x[n+1])), xlim = xlim, ylim = ylim) 
lines(density(res$PostDist_theta), lty = 1, col = c('blue'), lwd = 4)
leg.txt = c("Density estimation curve")
legend("topright", legend = leg.txt, lty = 1, col = c('blue'), lwd = 2)
savePlot(filename = "figure/N-NIG_Density_estimation_curve", type = c("pdf"))
savePlot(filename = "figure/N-NIG_Density_estimation_curve", type = c("jpg"))


####################################################
### code chunk number : Simulations: Two inequalities, v0 changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu0 = 3; mu0    ## hyperparameter
k0 = 1          ## hyperparameter
v0 = 2:11; v0   ## hyperparameter
sigma0 = 1      ## hyperparameter
u0 = sigma0^2 * (k0 + 1) / k0; u0
x_np1 = 4

L_v0 = length(v0); L_v0
delta_s = delta_2 = PESL_s = PESL_2 = rep(0, L_v0)
for (i in 1:L_v0){
	res_i = Compute_Estimators_PESLs_new(mu0, k0, v0[i], sigma0, x_np1)
	delta_s[i] = res_i$delta_s
	delta_2[i] = res_i$delta_2
	PESL_s[i] = res_i$PESL_s
	PESL_2[i] = res_i$PESL_2
}
delta_s
delta_2
PESL_s
PESL_2

## Generate_Matrix_Latex for B
B = round(rbind(delta_s, delta_2, PESL_s, PESL_2), 4)
Generate_Matrix_Latex(format(B, nsmall = 4))

## plot estimators and PESLs
plot_estimator(delta_s, delta_2, parameter = v0, para_name = "v0", xlab = expression(nu[0]), legend_pos = "topright", sub = "(a)")
plot_PESL(PESL_s, PESL_2, parameter = v0, para_name = "v0", xlab = expression(nu[0]), legend_pos = "topright", sub = "(b)")


####################################################
### code chunk number : Simulations: Two inequalities, mu0 changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu0 = -5:5; mu0 ## hyperparameter
k0 = 1          ## hyperparameter
v0 = 6; v0      ## hyperparameter
sigma0 = 1      ## hyperparameter
u0 = sigma0^2 * (k0 + 1) / k0; u0
x_np1 = 4

L_mu0 = length(mu0)
delta_s = delta_2 = PESL_s = PESL_2 = rep(0, L_mu0)
for (i in 1:L_mu0){
	res_i = Compute_Estimators_PESLs_new(mu0[i], k0, v0, sigma0, x_np1)
	delta_s[i] = res_i$delta_s
	delta_2[i] = res_i$delta_2
	PESL_s[i] = res_i$PESL_s
	PESL_2[i] = res_i$PESL_2
}
delta_s
delta_2
PESL_s
PESL_2

## Generate_Matrix_Latex for B
B = round(rbind(delta_s, delta_2, PESL_s, PESL_2), 4)
Generate_Matrix_Latex(format(B, nsmall = 4))

## plot estimators and PESLs
plot_estimator(delta_s, delta_2, parameter = mu0, para_name = "mu0", xlab = expression(mu[0]), legend_pos = "topright", sub = "(a)")
plot_PESL(PESL_s, PESL_2, parameter = mu0, para_name = "mu0", xlab = expression(mu[0]), legend_pos = "right", sub = "(b)")


####################################################
### code chunk number : Simulations: Two inequalities, k0 changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu0 = 3; mu0    ## hyperparameter
k0 = 1:10       ## hyperparameter
v0 = 6; v0      ## hyperparameter
sigma0 = 1      ## hyperparameter
u0 = sigma0^2 * (k0 + 1) / k0; u0
x_np1 = 4

L_k0 = length(k0)
delta_s = delta_2 = PESL_s = PESL_2 = rep(0, L_k0)
for (i in 1:L_k0){
	res_i = Compute_Estimators_PESLs_new(mu0, k0[i], v0, sigma0, x_np1)
	delta_s[i] = res_i$delta_s
	delta_2[i] = res_i$delta_2
	PESL_s[i] = res_i$PESL_s
	PESL_2[i] = res_i$PESL_2
}
delta_s
delta_2
PESL_s
PESL_2

## Generate_Matrix_Latex for B
B = round(rbind(delta_s, delta_2, PESL_s, PESL_2), 4)
Generate_Matrix_Latex(format(B, nsmall = 4))

## plot estimators and PESLs
plot_estimator(delta_s, delta_2, parameter = k0, para_name = "k0", xlab = expression(kappa[0]), legend_pos = "right", sub = "(c)")
plot_PESL(PESL_s, PESL_2, parameter = k0, para_name = "k0", xlab = expression(kappa[0]), legend_pos = "right", sub = "(d)")


####################################################
### code chunk number : Simulations: Two inequalities, sigma0 changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu0 = 3; mu0                           ## hyperparameter
k0 = 1                                 ## hyperparameter
v0 = 6                                 ## hyperparameter
sigma0 = sqrt(seq(0.5, 5, by = 0.5))   ## hyperparameter
u0 = sigma0^2 * (k0 + 1) / k0; u0
x_np1 = 4

L_sigma0 = length(sigma0)
delta_s = delta_2 = PESL_s = PESL_2 = rep(0, L_sigma0)
for (i in 1:L_sigma0){
	res_i = Compute_Estimators_PESLs_new(mu0, k0, v0, sigma0[i], x_np1)
	delta_s[i] = res_i$delta_s
	delta_2[i] = res_i$delta_2
	PESL_s[i] = res_i$PESL_s
	PESL_2[i] = res_i$PESL_2
}
delta_s
delta_2
PESL_s
PESL_2

## Generate_Matrix_Latex for B
B = round(rbind(delta_s, delta_2, PESL_s, PESL_2), 4)
Generate_Matrix_Latex(format(B, nsmall = 4))

## plot estimators and PESLs
plot_estimator(delta_s, delta_2, parameter = sigma0^2, para_name = "sigma02", xlab = expression(sigma[0]^2), legend_pos = "bottomright", sub = "(e)")
plot_PESL(PESL_s, PESL_2, parameter = sigma0^2, para_name = "sigma02", xlab = expression(sigma[0]^2), legend_pos = "right", sub = "(f)")


####################################################
### code chunk number : Simulations: Two inequalities, x_np1 changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu0 = 3; mu0    ## hyperparameter
k0 = 1          ## hyperparameter
v0 = 6; v0      ## hyperparameter
sigma0 = 1      ## hyperparameter
u0 = sigma0^2 * (k0 + 1) / k0; u0
x_np1 = -5:5

L_x_np1 = length(x_np1)
delta_s = delta_2 = PESL_s = PESL_2 = rep(0, L_x_np1)
for (i in 1:L_x_np1){
	res_i = Compute_Estimators_PESLs_new(mu0, k0, v0, sigma0, x_np1[i])
	delta_s[i] = res_i$delta_s
	delta_2[i] = res_i$delta_2
	PESL_s[i] = res_i$PESL_s
	PESL_2[i] = res_i$PESL_2
}
delta_s
delta_2
PESL_s
PESL_2

## Generate_Matrix_Latex for B
B = round(rbind(delta_s, delta_2, PESL_s, PESL_2), 4)
Generate_Matrix_Latex(format(B, nsmall = 4))

## plot estimators and PESLs
plot_estimator(delta_s, delta_2, parameter = x_np1, para_name = "x_np1", xlab = expression(x[n+1]), legend_pos = "right", sub = "(g)")
plot_PESL(PESL_s, PESL_2, parameter = x_np1, para_name = "x_np1", xlab = expression(x[n+1]), legend_pos = "right", sub = "(h)")


####################################################
### code chunk number : Simulations: Two inequalities, persp3d
####################################################
## 
## delta_s < delta_2 
## PESL_s <= PESL_2 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## Install the package for the first time.
## Note: omit the 's' in 'https' if you cannot handle https downloads.
# install.packages(pkgs = "rgl", repos = "https://cloud.r-project.org/", dependencies=TRUE)
library(rgl) ## Install the R package rgl first.

a = seq(1.1, 10, length = 20); L_a = length(a); L_a
b = seq(0.1, 10, length = 20); L_b = length(b); L_b

delta_s  = function(a, b){ b / a }
delta_2 = function(a, b){ b / (a - 1) }
PESL_s= function(a, b){ log(a) - digamma(a) }
PESL_2= function(a, b){ 1 / (a - 1) + log(a - 1) - digamma(a) }

delta_2_s = function(a, b){ delta_2(a, b) - delta_s(a, b) }
PESL_2_s = function(a, b){ PESL_2(a, b) - PESL_s(a, b) }

## Estimators
z_delta_s = outer(a, b, FUN = "delta_s")
range(z_delta_s)
dim(z_delta_s)

z_delta_2 = outer(a, b, FUN = "delta_2")
range(z_delta_2)
dim(z_delta_2)

range(z_delta_2 - z_delta_s)

z_delta_2_s = outer(a, b, FUN = "delta_2_s")
range(z_delta_2_s)

open3d()
persp3d(a, b, z_delta_2, col = "red", xlab = "a", ylab = "b", zlab = "Estimator")
persp3d(a, b, z_delta_s, col = "blue", add = TRUE)
rgl.postscript("figure/N-NIG_Estimators.pdf", "pdf")
rgl.snapshot(filename = "figure/N-NIG_Estimators.png", fmt = "png", top = TRUE)

open3d()
persp3d(a, b, z_delta_2_s,  col = "green", xlab = "a", ylab = "b", zlab = "delta[2](x) - delta[s](x)")
rgl.postscript("figure/N-NIG_delta_2_s.pdf", "pdf")
rgl.snapshot(filename = "figure/N-NIG_delta_2_s.png", fmt = "png", top = TRUE)

## PESL
z_PESL_2 = outer(a, b, FUN = "PESL_2")
range(z_PESL_2)
dim(z_PESL_2)

z_PESL_s = outer(a, b, FUN = "PESL_s")
range(z_PESL_s)
dim(z_PESL_s)

range(z_PESL_2 - z_PESL_s)

z_PESL_2_s = outer(a, b, FUN = "PESL_2_s")
range(z_PESL_2_s)

open3d()
persp3d(a, b, z_PESL_2, col = "red", xlab = "a", ylab = "b", zlab = "PESL")
persp3d(a, b, z_PESL_s, col = "blue", add = TRUE)
rgl.postscript("figure/N-NIG_PESLs.pdf", "pdf")
rgl.snapshot(filename = "figure/N-NIG_PESLs.png", fmt = "png", top = TRUE)

open3d()
persp3d(a, b, z_PESL_2_s,  col = "green", xlab = "a", ylab = "b", zlab = "PESL[2](x) - PESL[s](x)")
rgl.postscript("figure/N-NIG_PESL_2_s.pdf", "pdf")
rgl.snapshot(filename = "figure/N-NIG_PESL_2_s.png", fmt = "png", top = TRUE)

